/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.dialogs.AddRemoteDialog;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.actions.Messages;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IPath;

public class AddRemoteHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        GitRepository theRepo = this.getSelectedRepository();
        if (theRepo == null && this.getSelectedResources() != null && this.getSelectedResources().size() != 1) {
            this.openError(Messages.CommitAction_MultipleRepos_Title, Messages.CommitAction_MultipleRepos_Message);
            return null;
        }
        if (theRepo == null || this.getSelectedResources() == null || this.getSelectedResources().isEmpty()) {
            this.openError(Messages.CommitAction_NoRepo_Title, Messages.CommitAction_NoRepo_Message);
            return null;
        }
        String name = "origin";
        String url = "";
        String username = System.getProperty("user.name");
        if (username == null || username.length() == 0) {
            username = "user";
        }
        String reponame = "repo";
        GitRepository repo = this.getSelectedRepository();
        IPath wd = repo.workingDirectory();
        reponame = wd.lastSegment();
        if (reponame.endsWith(".git")) {
            reponame = reponame.substring(0, reponame.length() - 4);
        }
        url = MessageFormat.format("git@github.com:{0}/{1}.git", username, reponame);
        AddRemoteDialog dialog = new AddRemoteDialog(this.getShell(), repo, name, url);
        if (dialog.open() == 0) {
            name = dialog.getRemoteName().trim();
            url = dialog.getRemoteURL();
            theRepo.addRemote(name, url, dialog.track());
        }
        return null;
    }
}

